
module FHGelsenkirchen
  class AttributeEdit
    @@stdAvailableBuildingAttributes = ['id','description','name','creationDate','terminationDate','class','function','usage','yearOfConstruction','yearOfDemolition','roofType','measuredHeight','storeysAboveGround','storeysBelowGround','storeyHeightsAboveGround','storeyHeightsBelowGround',]
    @@stdAvailableSurfaceAttributes = ['BoundarySurfaceType ID','PolygonID','LinearRingID']

    def self.AvailableBuildingAttributes
      @@stdAvailableBuildingAttributes
    end

    def initialize
      @entity = Sketchup.active_model.selection.first
      if(@entity.class != Sketchup::Face and @entity.class != Sketchup::Group and @entity.class != Sketchup::ComponentInstance)
        return;
      end

      Sketchup.active_model.start_operation("Edit attributes");

      @stdDict = @entity.attribute_dictionary("Standard attribute",true)
      @genDict = @entity.attribute_dictionary("Generic attribute",true)

      @dlgOpen = true;
      @dlg = UI::WebDialog.new("Edit attributes", true, "AM");
      @dlg.set_file(File.dirname(__FILE__) + "/../Dialog/edit.html");
      @dlg.set_size 600, 500;
      @dlg.add_action_callback("LoadAvailableStdAttributes") {|dialog, params| OnLoadAvailableStdAttributes(dialog,params);}
      @dlg.add_action_callback("ImportStandardAttributes") {|dialog, params|  OnImportStandardAttributes(dialog,params); }
      @dlg.add_action_callback("ImportGenericAttributes") {|dialog, params|  OnImportGenericAttributes(dialog,params); }

      @dlg.add_action_callback("AddAttribute") {|dialog, params|  OnAddAttribute(dialog, params); }
      @dlg.add_action_callback("RemoveAttribute") {|dialog, params|  OnRemoveAttribute(dialog, params); }

      @dlg.add_action_callback("Accept") {|dialog, params| OnAccept(dialog,params);}
      @dlg.add_action_callback("Cancel") {|dialog, params| OnCancel(dialog,params);}
      @dlg.set_on_close { OnClose();}
      @dlg.show();
    end

    def OnLoadAvailableStdAttributes(dialog, params)
      script = "OnLoadAvailableStdAttributes('";
      first = true;

      if(@entity.class == Sketchup::Face)
        stdAttributes = @@stdAvailableSurfaceAttributes
      else
        stdAttributes = @@stdAvailableBuildingAttributes
      end
      stdAttributes.each do |e|
        if(!first)
          script << "|"
        else
          first = false
        end
        script << e
      end
      script << "')";
      @dlg.execute_script(script);
    end

    def OnImportStandardAttributes(dialog, params)
      script = "OnImportStandardAttributes('{";
      first = true;
      @stdDict.each do |k,v|
        if(first)
          first = false;
        else
          script << ',';
        end
        script << '"' << FHGelsenkirchen::stringDecode(k) << '":"' << FHGelsenkirchen::stringDecode(v) << '"'
      end
      script << "}');";
      @dlg.execute_script(script);
    end

    def OnImportGenericAttributes(dialog, params)
      script = "OnImportGenericAttributes('{";
      first = true;
      @genDict.each do |k,v|
        if(first)
          first = false;
        else
          script << ',';
        end
        script << '"' << FHGelsenkirchen::stringDecode(k) << '":"' << FHGelsenkirchen::stringDecode(v) << '"'
      end
      script << "}');";
      @dlg.execute_script(script);
    end

    def OnAddAttribute(dialog, params)
      p = params.split('##||##')

      if(p.length == 3)
        if(p[0] == 'std')
          @entity.set_attribute("Standard attribute",FHGelsenkirchen::stringEncode(p[1]),FHGelsenkirchen::stringEncode(p[2]));
        elsif(p[0] == 'gen')
          @entity.set_attribute("Generic attribute",FHGelsenkirchen::stringEncode(p[1]),FHGelsenkirchen::stringEncode(p[2]));
        end
      end
	  #@genDict.each  do |k, v|
		#	puts "#{k.to_s()}"  
		#end
    end

    def OnRemoveAttribute(dialog, params)
      p = params.split('##||##')
      if(p.length == 2)
        if(p[0] == 'std')
          @entity.delete_attribute("Standard attribute",FHGelsenkirchen::stringEncode(p[1]));
        elsif(p[0] == 'gen')
          @entity.delete_attribute("Generic attribute",FHGelsenkirchen::stringEncode(p[1]));
        end
      end
    end

    def OnAccept(dialog, params)
      @dlgOpen = false;
      Sketchup.active_model.commit_operation();

      @dlg.close();
    end

    def OnCancel(dialog, params)
      @dlgOpen = false;
      Sketchup.active_model.abort_operation();
      @dlg.close();
    end

    def OnClose()
      if(@dlgOpen)
        Sketchup.active_model.abort_operation();
      end
    end
  end

  def FHGelsenkirchen::setid(entities, id)
    entities.each do |e|
      if(e.class == Sketchup::Face)
        begin
          #e.set_attribute "Standard attribute", "SurfaceType", type
          e.set_attribute("Standard attribute", "BoundarySurfaceType ID", id)
        rescue => err
          puts err
        end
      elsif(e.class == Sketchup::Group)
        setid(e.entities, id)
      elsif(e.class == Sketchup::ComponentInstance)
        setid(e.definition.entities, id)
      end
    end
  end

  def FHGelsenkirchen::setsurfacetype(entities, type)
    @wallsurface = false
    @roofsurface = false
    @groundsurface = false
    @relieffeature = false
    entities.each do |e|
      if(e.class == Sketchup::Face)
        if(type != nil)
          begin
            #e.set_attribute "Standard attribute", "SurfaceType", type
            e.layer= type
          rescue => err
            e.layer= Sketchup.active_model.layers.add(type)
          end
        else
          begin
            #e.delete_attribute "Standard attribute", "SurfaceType"
            face.layer= "No Surfacetype"
          rescue => err
            e.layer= Sketchup.active_model.layers.add("No Surfacetype")
          end
        end
      elsif(e.class == Sketchup::Group)
        setsurfacetype(e.entities, type)
      elsif(e.class == Sketchup::ComponentInstance)
        setsurfacetype(e.definition.entities, type)
      end
    end
  end

  def FHGelsenkirchen::setsurfaceid(entities, hash)
    entities.each do |e|
      if(e.class == Sketchup::Face)
        id = e.get_attribute("Standard attribute", "BoundarySurfaceType ID", "")
        if(hash[e.layer.name] == nil)
          hash[e.layer.name] = Hash.new
        end
        if(hash[e.layer.name][id] == nil)
          hash[e.layer.name][id] = 1
        else
          hash[e.layer.name][id] += 1
        end
      elsif(e.class == Sketchup::Group)
        setsurfaceid(e.entities, hash)
      elsif(e.class == Sketchup::ComponentInstance)
        setsurfaceid(e.definition.entities, hash)
      end
    end
    return hash
  end

  def FHGelsenkirchen::hasface?(entities)
    entities.each do |e|
      if(e.class == Sketchup::Face)
        return true
      elsif(e.class == Sketchup::Group)
        return hasface?(e.entities)
      elsif(e.class == Sketchup::ComponentInstance)
        return hasface?(e.definition.entities)
      end
    end
    return false
  end

  def FHGelsenkirchen::findtype(entities, typehash)
    entities.each do |e|
      if(e.class == Sketchup::Face)
        value = nil #= e.get_attribute "Standard attribute", "SurfaceType", nil
        #value = e.layer.name
        #if(e.layer.name != value)
        if(e.layer.name == "GroundSurface" or e.layer.name == "WallSurface" or e.layer.name == "RoofSurface" or e.layer.name == "ReliefFeature" or e.layer.name == "No Surfacetype")
          #e.set_attribute "Standard attribute", "SurfaceType", e.layer.name
          value = e.layer.name
        end
        #end
        if(value != nil)
          if(typehash[value] == nil)
            typehash[value] = 1
          else
            typehash[value] += 1
          end
        end
      elsif(e.class == Sketchup::Group)
        findtype(e.entities, typehash)
      elsif(e.class == Sketchup::ComponentInstance)
        findtype(e.definition.entities, typehash)
      end
    end
  end

  def FHGelsenkirchen::stringEncode(s)
    if(s == nil)
      return nil
    end
    coder = HTMLEntities.new
    return coder.encode(str_filter(s), :named)
  end

  def FHGelsenkirchen::stringDecode(s)
    if(s == nil)
      return nil
    end
    coder = HTMLEntities.new
    return coder.decode(s)
  end

  def FHGelsenkirchen::str_filter(s)
    if(s == nil)
      return nil
    end
    str = s;

    str.gsub!(/\u0080/,'€')
    str.gsub!(/\u0083/,'ƒ')
    str.gsub!(/\u0089/,'‰')

    str.gsub!(/\u00A7/,'§')
    str.gsub!(/\u00A9/,'©')

    str.gsub!(/\u00B0/,'°')
    str.gsub!(/\u00B5/,'µ')

    str.gsub!(/\u00C4/,'Ä')

    str.gsub!(/\u00D6/,'Ö')
    str.gsub!(/\u00DC/,'Ü')
    str.gsub!(/\u00DF/,'ß')

    str.gsub!(/\u00E4/,'ä')

    str.gsub!(/\u00F6/,'ö')
    str.gsub!(/\u00FC/,'ü')

    return str
  end
end